import org.uddi4j.client.UDDIProxy;
import org.uddi4j.response.BusinessInfo;
import org.uddi4j.response.BusinessInfos;
import org.uddi4j.response.BusinessList;
import org.uddi4j.transport.TransportFactory;
import org.uddi4j.util.FindQualifier;
import org.uddi4j.util.FindQualifiers;
import org.uddi4j.util.IdentifierBag;
import org.uddi4j.util.KeyedReference;
import java.util.Vector;

public class UDDIFindBusiness13 {

	public static void main(String[] args) throws Exception {

		System.setProperty(TransportFactory.PROPERTY_NAME, "org.uddi4j.transport.ApacheAxisTransport");

		UDDIProxy proxy = new UDDIProxy();
		proxy.setInquiryURL("http://uddi.microsoft.com/inquire");

		Vector ibv = new Vector();
		KeyedReference kr = new KeyedReference("", "789388907");
	 	kr.setTModelKey("uuid:8609C81E-EE1F-4D5A-B202-3EB13AD01823");
		ibv.addElement(kr);
		kr = new KeyedReference("", "007932671");
	 	kr.setTModelKey("uuid:8609C81E-EE1F-4D5A-B202-3EB13AD01823");
		ibv.addElement(kr);
		IdentifierBag ib = new IdentifierBag();
		ib.setKeyedReferenceVector(ibv);

		Vector fqv = new Vector();
		FindQualifier fq = new FindQualifier(FindQualifier.sortByNameDesc);
		fqv.add(fq);
		FindQualifiers fqs = new FindQualifiers();
		fqs.setFindQualifierVector(fqv);

		BusinessList bl = proxy.find_business(null, null, ib, null, null, fqs, 0);

		BusinessInfos bis = bl.getBusinessInfos();
		if (bis.size() == 0) {
			System.out.println("no business(es) found");
			System.exit(0);
		}

		System.out.println(bis.size()+" business(es) found\n");
		Vector biv = bis.getBusinessInfoVector();
		for (int i = 0; i < biv.size(); i++) {
			BusinessInfo bi = (BusinessInfo)biv.elementAt(i);
			System.out.println(bi.getNameString());
			System.out.println(bi.getBusinessKey());
			System.out.println("\n");
		}
	}
}